/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.spinner;

import de.sillysky.nyssr.impl.remoteskin.client.swing.util.CUtilDisplay;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingJComponent;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingSlider;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CUtilReference;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import java.awt.Component;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingSpinner
extends CSwingJComponent {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingSlider.class);
    private final JSpinner mComponent;
    private final AtomicBoolean mValueChangeInProgress = new AtomicBoolean();
    private boolean mOnChange = false;
    private CWidget mDisplayWidget = null;

    CSwingSpinner(@NotNull CWidgetSet aWidgetSet, @NotNull String aId) {
        super(aWidgetSet, aId);
        this.mComponent = new JSpinner();
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("display", this::applyDisplay);
        list.addHandler("wantChange", this::applyWantChange);
    }

    private boolean applyDisplay(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof String) {
            String id = (String)aValue;
            if (CUtilReference.isWidgetId((String)id)) {
                this.mDisplayWidget = this.getWidgetSet().findWidget(id);
            }
            this.doDisplay();
            this.getComponent().addChangeListener(e -> this.doDisplay());
            return true;
        }
        return false;
    }

    private boolean applyWantChange(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOnChange = (Boolean)aValue;
            return true;
        }
        return false;
    }

    protected String getValueString() {
        JSpinner spinner = this.getComponent();
        Object value = spinner.getValue();
        return value.toString();
    }

    protected void doDisplay() {
        if (this.mDisplayWidget != null) {
            Component display = this.mDisplayWidget.getComponent();
            String str = this.getValueString();
            CUtilDisplay.display(display, str);
        }
    }

    protected void onChange(@NotNull ChangeEvent aEvent) {
        String value;
        if (this.isOnChange() && (value = this.getValueString()) != null) {
            LOG.debug("value is {}", new Object[]{value});
            this.addNotification("onChangeDouble", value);
            this.sendNotification();
        }
    }

    @NotNull
    public JSpinner getComponent() {
        return this.mComponent;
    }

    protected boolean isOnChange() {
        return this.mOnChange;
    }

    protected void startEdit() {
        this.mValueChangeInProgress.set(true);
    }

    protected void stopEdit() {
        this.mValueChangeInProgress.set(false);
    }

    protected boolean isEditInProgress() {
        return this.mValueChangeInProgress.get();
    }
}

