/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.packet.factory.message;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.impl.network.packet.factory.message.CPacketMessage;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.files.CResourceHandler;
import de.sillysky.nyssr.util.streamheader.CBasicStreamHeader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.List;

final class CStreamHeaderDebug
extends CBasicStreamHeader<CPacketMessage> {
    private final List<CNodeAddress> mHops = new ArrayList<CNodeAddress>();
    private int mSequenceNumber;

    CStreamHeaderDebug(CPacketMessage aOwner) {
        super(3, (Object)aOwner, null);
    }

    CStreamHeaderDebug(CPacketMessage aOwner, byte[] aBytes) {
        super(3, (Object)aOwner, aBytes);
    }

    void addHop(CNodeAddress aHop) {
        this.mHops.add(aHop);
        this.setPackedHeaderBytes(null);
    }

    int getSequenceNumber() {
        return this.mSequenceNumber;
    }

    void setSequenceNumber(int aSequenceNumber) {
        this.mSequenceNumber = aSequenceNumber;
    }

    public void pack() {
        if (this.getPackedData() != null) {
            return;
        }
        CResourceHandler<byte[]> handler = new CResourceHandler<byte[]>(){

            protected byte[] doResourceHandling() throws Exception {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                this.registerResource(dos);
                CPositiveInteger.toStream((DataOutput)dos, (int)CStreamHeaderDebug.this.mSequenceNumber);
                CPositiveInteger.toStream((DataOutput)dos, (int)CStreamHeaderDebug.this.mHops.size());
                for (CNodeAddress node : CStreamHeaderDebug.this.mHops) {
                    CNodeAddress.toStream((DataOutput)dos, (CNodeAddress)node);
                }
                dos.close();
                return baos.toByteArray();
            }
        };
        CResult error = handler.run();
        if (error != null) {
            handler.log();
        }
        byte[] result = (byte[])handler.getResult();
        this.setPackedHeaderBytes(result);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(120);
        sb.append("no=");
        sb.append(this.mSequenceNumber);
        if (this.mHops.size() > 0) {
            sb.append(" hops=");
            int i = 0;
            for (CNodeAddress hop : this.mHops) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(hop);
                ++i;
            }
        }
        return sb.toString();
    }

    public void unpack() {
        final byte[] packedData = this.getPackedData();
        if (packedData == null) {
            return;
        }
        CResourceHandler<byte[]> handler = new CResourceHandler<byte[]>(this){
            final /* synthetic */ CStreamHeaderDebug this$0;
            {
                this.this$0 = this$0;
            }

            protected byte[] doResourceHandling() throws Exception {
                ByteArrayInputStream bais = new ByteArrayInputStream(packedData);
                DataInputStream dis = new DataInputStream(bais);
                this.registerResource(dis);
                this.this$0.mSequenceNumber = CPositiveInteger.fromStream((DataInput)dis);
                int hopCount = CPositiveInteger.fromStream((DataInput)dis);
                for (int i = 0; i < hopCount; ++i) {
                    CNodeAddress node = CNodeAddress.fromStream((DataInput)dis);
                    this.this$0.mHops.add(node);
                }
                return null;
            }
        };
        CResult error = handler.run();
        if (error != null) {
            handler.log();
        }
    }
}

