/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.packet.factory.message;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.impl.network.packet.factory.message.CPacketMessage;
import de.sillysky.nyssr.impl.network.packet.factory.message.CPacketMessageHeaderFactory;
import de.sillysky.nyssr.impl.network.packet.factory.message.IDependencies;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.network.packets.EPacketType;
import de.sillysky.nyssr.network.packets.IPacket;
import de.sillysky.nyssr.network.packets.IPacketFactory;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.util.streamheader.CStreamHeaderFactoryRegistry;
import de.sillysky.nyssr.util.streamheader.CStreamHeaderList;
import de.sillysky.nyssr.util.streamheader.IStreamHeaderFactory;
import java.io.DataInput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

final class CPacketFactoryMessage
implements IPacketFactory,
IService {
    private final IDependencies mDependencies;
    private CStreamHeaderFactoryRegistry<CPacketMessage> mHeaderFactoryRegistry;
    private CNodeAddress mLocalNode;
    private int mRunningNo = 0;

    public CPacketFactoryMessage(IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mLocalNode = this.mDependencies.getKernelConfiguration().getNodeAddress();
        this.mHeaderFactoryRegistry = new CStreamHeaderFactoryRegistry();
        CPacketMessageHeaderFactory factory = new CPacketMessageHeaderFactory();
        this.mHeaderFactoryRegistry.registerFactory(1, (IStreamHeaderFactory)factory);
        this.mHeaderFactoryRegistry.registerFactory(2, (IStreamHeaderFactory)factory);
        this.mHeaderFactoryRegistry.registerFactory(3, (IStreamHeaderFactory)factory);
        this.mDependencies.getPacketFactoryRegistry().registerPacketFactory(this);
    }

    @Override
    @NotNull
    public IPacket fromObject(@NotNull Object aObject) {
        ++this.mRunningNo;
        if (this.mRunningNo < 0) {
            this.mRunningNo = 0;
        }
        return new CPacketMessage(this.mDependencies.getNodeInfoDatabase(), this.mDependencies.getPacketBuilderRegistry(), (CMessage)aObject, this.mRunningNo, this.mLocalNode);
    }

    @Override
    @NotNull
    public IPacket fromStream(@NotNull DataInput aStream, boolean aIsTest) throws IOException {
        CStreamHeaderList list = new CStreamHeaderList();
        list.unpack(aStream, null, this.mHeaderFactoryRegistry);
        return new CPacketMessage(this.mDependencies.getNodeInfoDatabase(), this.mDependencies.getPacketBuilderRegistry(), (CStreamHeaderList<CPacketMessage>)list);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mDependencies.getPacketFactoryRegistry().deregisterPacketFactory(this);
    }

    @Override
    public EPacketType getType() {
        return EPacketType.MESSAGE;
    }
}

