/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.packet.builder.zip;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.network.packet.builder.zip.IDependencies;
import de.sillysky.nyssr.impl.network.packet.factory.message.CPacketMessage;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfoDto;
import de.sillysky.nyssr.network.packets.IPacket;
import de.sillysky.nyssr.network.packets.IPacketBuilder;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jetbrains.annotations.NotNull;

final class CPacketBuilderZip
implements IPacketBuilder,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CPacketBuilderZip.class);
    private static final int BUFFER_SIZE = 500;
    private static final int RESERVED = 1000;
    @NotNull
    private final IDependencies mDependencies;

    public CPacketBuilderZip(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mDependencies.getPacketBuilderRegistry().registerPacketBuilder(this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mDependencies.getPacketBuilderRegistry().deregisterPacketBuilder(this);
    }

    @Override
    public char getType() {
        return 'Z';
    }

    @Override
    public void pack(IPacket aPacket, CNodeInfoDto aNodeInfo) throws CException {
        if (aPacket instanceof CPacketMessage) {
            CPacketMessage packet = (CPacketMessage)aPacket;
            byte[] payload = packet.getPayload();
            if (payload == null) {
                throw new CException(7).append("Payload is null.");
            }
            int unpackedSize = payload.length;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream(unpackedSize + 1000);
                 GZIPOutputStream zip = new GZIPOutputStream(baos);){
                zip.write(payload, 0, unpackedSize);
                zip.flush();
                zip.finish();
                int packedSize = baos.size();
                if (packedSize < unpackedSize) {
                    String builderFlags = packet.getBuilderSequence();
                    packet.setBuilderSequence(builderFlags + this.getType());
                    byte[] data = baos.toByteArray();
                    packet.setPayload(data);
                    int percentage = 100 - 100 * packedSize / unpackedSize;
                    LOG.debug("Packet ZIP: lengthBefore={}, lengthAfter={}, gain={}", new Object[]{unpackedSize, packedSize, percentage});
                }
            }
            catch (IOException e) {
                throw new CException((Throwable)e);
            }
        }
    }

    @Override
    public void unpack(IPacket aPacket, CNodeInfoDto aNodeInfo) throws CException {
        if (aPacket instanceof CPacketMessage) {
            CPacketMessage packet = (CPacketMessage)aPacket;
            byte[] payload = packet.getPayload();
            if (payload == null) {
                throw new CException(7).append("Payload is null.");
            }
            try (ByteArrayInputStream bais = new ByteArrayInputStream(payload);
                 GZIPInputStream zip = new GZIPInputStream(bais);){
                int read;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] data1 = new byte[500];
                do {
                    if ((read = zip.read(data1)) <= 0) continue;
                    baos.write(data1, 0, read);
                } while (read != -1);
                baos.flush();
                byte[] data2 = baos.toByteArray();
                int ratio = 100 * payload.length / data2.length;
                LOG.trace("ZIP: unpack {} bytes from {} compressed bytes, ratio = {}%.", new Object[]{data2.length, payload.length, ratio});
                packet.setPayload(data2);
                packet.removeBuilderFlag(this.getType());
            }
            catch (IOException e) {
                LOG.error((Throwable)e, "Error decompressing zipped message.");
                LOG.error("Packet = {}", new Object[]{packet});
                throw new CException(2).append((Object)e);
            }
        }
    }
}

