/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.hints.routing;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.impl.network.hints.routing.CRoutingHintEntry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CRoutingHint;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

class CRoutingHintList {
    private static final ILogger LOG = CLoggerFactory.getLogger((String)"network.routing.hint");
    private final Map<CNodeAddress, CRoutingHintEntry> mHints = new ConcurrentHashMap<CNodeAddress, CRoutingHintEntry>();

    CRoutingHintList() {
    }

    void add(@NotNull CRoutingHint aRoutingHint) {
        CRoutingHintEntry entry = new CRoutingHintEntry(aRoutingHint.getIdOfBridgeNode());
        this.mHints.put(aRoutingHint.getAddressOfUnknownNode(), entry);
        LOG.debug("RoutingHints: add {}, now {} entries", new Object[]{aRoutingHint, this.mHints.size()});
    }

    void remove(@NotNull CNodeAddress aAddressOfUnknownNode) {
        this.mHints.remove(aAddressOfUnknownNode);
    }

    CNodeId getBridgeNode(@NotNull CNodeAddress aAddressOfUnknownNode) {
        CRoutingHintEntry entry = this.mHints.get(aAddressOfUnknownNode);
        if (entry != null) {
            entry.updateTime();
            return entry.getBridge();
        }
        return null;
    }

    public void checkExpiration() {
        long now = System.currentTimeMillis();
        this.mHints.values().removeIf(entry -> entry.isExpired(now));
    }
}

