/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.enums.EWindowState;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetId;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventWindowNotification
implements IRemoteSkinEvent {
    public static final String WIDGET_ID_OPPOSITE_WINDOW = "opposite";
    public static final String NEW_STATE = "newState";
    public static final String OLD_STATE = "oldState";
    private final CWidgetId mOppositeWindow;
    private final EWindowState mNewState;
    private final EWindowState mOldState;

    public CEventWindowNotification(@Nullable CWidgetId aOppositeWindow, @NotNull EWindowState aNewState, @Nullable EWindowState aOldState) {
        this.mOppositeWindow = aOppositeWindow;
        this.mNewState = aNewState;
        this.mOldState = aOldState == null ? EWindowState.unknown : aOldState;
    }

    @Nullable
    public static CEventWindowNotification create(@Nullable Object aValue) {
        CJsonObject jo;
        String name;
        EWindowState newState;
        if (aValue instanceof CJsonObject && (newState = (EWindowState)((Object)CUtilEnum.fromString(EWindowState.class, (String)(name = CUtilJsonString.fromJson((CJsonObject)(jo = (CJsonObject)aValue), (String)NEW_STATE, null)), null))) != null) {
            name = CUtilJsonString.fromJson((CJsonObject)jo, (String)OLD_STATE, null);
            EWindowState oldState = (EWindowState)((Object)CUtilEnum.fromString(EWindowState.class, (String)name, (Object)((Object)EWindowState.unknown)));
            CEventWidgetId oppositeWindow = CEventWidgetId.create(jo.getValue(WIDGET_ID_OPPOSITE_WINDOW));
            return new CEventWindowNotification(oppositeWindow == null ? null : oppositeWindow.getWidgetId(), newState, oldState);
        }
        return null;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(NEW_STATE, (Object)this.mNewState.name());
        if (this.mOldState != EWindowState.unknown) {
            jo.put(OLD_STATE, (Object)this.mOldState.name());
        }
        if (this.mOppositeWindow != null) {
            CEventWidgetId dw = new CEventWidgetId(this.mOppositeWindow);
            jo.put(WIDGET_ID_OPPOSITE_WINDOW, dw.toJson());
        }
        return jo;
    }

    @Nullable
    public CWidgetId getOppositeWindow() {
        return this.mOppositeWindow;
    }

    @NotNull
    public EWindowState getNewState() {
        return this.mNewState;
    }

    @NotNull
    public EWindowState getOldState() {
        return this.mOldState;
    }
}

