/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventFont;
import de.sillysky.nyssr.remoteskin.model.events.CEventIcon;
import de.sillysky.nyssr.remoteskin.model.events.CEventText;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.remoteskin.model.events.border.CJsonBorderUtil;
import de.sillysky.nyssr.remoteskin.model.events.border.IBorder;
import de.sillysky.nyssr.util.CUtilString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventLabelAttributes
implements IRemoteSkinEvent {
    static final String VALUE = "value";
    static final String ICON = "icon";
    static final String BACKGROUND = "background";
    static final String FOREGROUND = "foreground";
    static final String BORDER = "border";
    static final String FONT = "font";
    static final String TOOLTIP = "tooltip";
    private CEventColor mBackground;
    private IBorder mBorder;
    private CEventFont mFont;
    private CEventColor mForeground;
    private CEventIcon mIcon;
    private String mTooltip;
    private Object mValue;

    public CEventLabelAttributes() {
    }

    public CEventLabelAttributes(@NotNull CEventLabelAttributes aOther) {
        this.takeOver(aOther);
    }

    @Nullable
    public static CEventLabelAttributes create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            CEventLabelAttributes event = new CEventLabelAttributes();
            Object value = jo.getValue(VALUE);
            event.setValue(value);
            CEventIcon icon = CEventIcon.fromObject(jo.getValue(ICON));
            event.setIcon(icon);
            CEventColor background = CEventColor.create(jo.getValue(BACKGROUND));
            event.setBackground(background);
            CEventColor foreground = CEventColor.create(jo.getValue(FOREGROUND));
            event.setForeground(foreground);
            IBorder border = CJsonBorderUtil.createBorder(jo);
            event.setBorder(border);
            CEventFont font = CEventFont.create(jo.getValue(FONT));
            event.setFont(font);
            String tooltip = CUtilJsonString.fromJson((CJsonObject)jo, (String)TOOLTIP, null);
            event.setTooltip(tooltip);
            return event;
        }
        return null;
    }

    public String toString() {
        return this.getDisplayedText();
    }

    public Object getValue() {
        return this.mValue;
    }

    public void setValue(Object aValue) {
        this.mValue = aValue;
    }

    public String getDisplayedText() {
        if (this.mValue instanceof CEventText) {
            CEventText event = (CEventText)this.mValue;
            return event.getText();
        }
        return this.mValue == null ? "" : this.mValue.toString();
    }

    public CEventIcon getIcon() {
        return this.mIcon;
    }

    public void setIcon(CEventIcon aIcon) {
        this.mIcon = aIcon;
    }

    public CEventFont getFont() {
        return this.mFont;
    }

    public void setFont(CEventFont aFont) {
        this.mFont = aFont;
    }

    public IBorder getBorder() {
        return this.mBorder;
    }

    public void setBorder(IBorder aBorder) {
        this.mBorder = aBorder;
    }

    public CEventColor getBackground() {
        return this.mBackground;
    }

    public void setBackground(CEventColor aBackground) {
        this.mBackground = aBackground;
    }

    public CEventColor getForeground() {
        return this.mForeground;
    }

    public void setForeground(CEventColor aForeground) {
        this.mForeground = aForeground;
    }

    public void toJson(@NotNull CJsonObject jo) {
        Object o;
        if (this.mValue != null) {
            if (this.mValue instanceof IRemoteSkinEvent) {
                jo.put(VALUE, ((IRemoteSkinEvent)this.mValue).toJson());
            } else {
                jo.put(VALUE, this.mValue);
            }
        }
        if (this.mIcon != null) {
            o = this.mIcon.toJson();
            jo.put(ICON, o);
        }
        if (this.mBackground != null) {
            o = this.mBackground.toJson();
            jo.put(BACKGROUND, o);
        }
        if (this.mForeground != null) {
            o = this.mForeground.toJson();
            jo.put(FOREGROUND, o);
        }
        if (this.mBorder != null) {
            o = this.mBorder.toJson();
            jo.put(BORDER, o);
        }
        if (this.mFont != null) {
            o = this.mFont.toJson();
            jo.put(FONT, o);
        }
        if (CUtilString.isValid((String)this.mTooltip)) {
            jo.put(TOOLTIP, (Object)this.mTooltip);
        }
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        this.toJson(jo);
        return jo;
    }

    public String getTooltip() {
        return this.mTooltip;
    }

    public void setTooltip(String aTooltip) {
        this.mTooltip = aTooltip;
    }

    void takeOver(@NotNull CEventLabelAttributes aOther) {
        this.mBackground = aOther.mBackground;
        this.mBorder = aOther.mBorder;
        this.mFont = aOther.mFont;
        this.mForeground = aOther.mForeground;
        this.mIcon = aOther.mIcon;
        this.mTooltip = aOther.mTooltip;
        this.mValue = aOther.mValue;
    }

    public void update(@NotNull CEventLabelAttributes aOther) {
        this.takeOver(aOther);
    }
}

