/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.message.panel;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.message.panel.CMessagePanelInstanceTarget;
import de.sillysky.nyssr.impl.message.panel.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.panel.CConstants;
import de.sillysky.nyssr.message.panel.records.CRecordOpenDialogMessagePanel;
import de.sillysky.nyssr.microservice.collector.CMicroServiceDescription;
import de.sillysky.nyssr.microservice.collector.CMicroServiceInstance;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.nanoservice.CDescriptionOfRecord;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.server.dialog.CBasicDialogFactory;
import de.sillysky.nyssr.remoteskin.server.dialog.CDialogDto;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.awt.Color;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;

class CMessagePanelFactory
extends CBasicDialogFactory
implements IService {
    private static final ILogger LOG = CLoggerFactory.getLogger((String)"dialog.messagepanel");
    private final IDependencies mDependencies;
    private IId mMicroServiceInstanceId;

    public CMessagePanelFactory(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordOpenDialogMessagePanel.ID, this::asyncOpenDialogMessagePanel);
        IId nid = CIdFactory.random((String)"DialogMessagePanel");
        INamespace namespace = this.mDependencies.getNamespaceFactory().createAndRegisterNamespace(nid, "DialogMessagePanel");
        namespace.getTargetRegistry().registerTarget((ITarget)this, nid);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        this.deregisterMicroService();
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.createMicroServiceInstanceId();
        this.registerMicroService();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncOpenDialogMessagePanel(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CDialogDto dto = this.checkStartDialog(aEnvelope, aRecord);
        int panelType = CRecordOpenDialogMessagePanel.getPanelType((CRecord)aRecord, (int)400);
        if (panelType != 400) {
            aEnvelope.setResult(5, "Unknown Panel ID " + panelType);
            return true;
        }
        CWidgetId centerAbove = CRecordOpenDialogMessagePanel.getCenterDlgAbove((CRecord)aRecord, null);
        Color background = CRecordOpenDialogMessagePanel.getBackground((CRecord)aRecord, null);
        Color foreground = CRecordOpenDialogMessagePanel.getForeground((CRecord)aRecord, null);
        Preferences preferences = this.mDependencies.getKernelConfiguration().getPreferences("dialogMessagePanel");
        LOG.debug("Start Dialog MessagePanel instance for {}.", new Object[]{aEnvelope.getSender()});
        CMessagePanelInstanceTarget tgt = new CMessagePanelInstanceTarget(this.mDependencies, dto, preferences, panelType, centerAbove, background, foreground);
        this.getTargetRegistry().registerTarget((ITarget)tgt);
        this.addDialog(tgt);
        CRecordOpenDialogMessagePanel.setDialogTargetAddress((CRecord)aRecord, (CTargetAddress)tgt.getAddress());
        aEnvelope.setResultSuccess();
        return true;
    }

    private void createMicroServiceInstanceId() {
        Preferences preferences = this.mDependencies.getKernelConfiguration().getPreferences("dialogMessagePanel");
        String s = preferences.get("microservice.instance.id", null);
        if (s == null) {
            this.mMicroServiceInstanceId = CNodeId.getLocal().getId();
            LOG.warn("Couldn't found MessagePanelMicroService configuration key {}: Take NodeId instead: {}", new Object[]{"microservice.instance.id", this.mMicroServiceInstanceId});
        } else {
            this.mMicroServiceInstanceId = CIdFactory.fromObject((Object)s);
            LOG.info("Instance ID for MessagePanelMicroService is {}", new Object[]{this.mMicroServiceInstanceId});
        }
    }

    private void registerMicroService() throws CException {
        CTargetAddress address = this.getAddress();
        ArrayList<CDescriptionOfRecord> list = new ArrayList<CDescriptionOfRecord>();
        list.add(new CDescriptionOfRecord(CRecordOpenDialogMessagePanel.ID, "Embed a Message History Panel"));
        CMicroServiceDescription desc = new CMicroServiceDescription(CConstants.MESSAGE_HISTORY_PANEL, "Embed a Message History Panel", list);
        CMicroServiceInstance inst = new CMicroServiceInstance(desc, this.mMicroServiceInstanceId, address);
        this.mDependencies.getHelperForLocalMicroServices().registerMicroService(inst);
    }

    private void deregisterMicroService() throws CException {
        this.mDependencies.getHelperForLocalMicroServices().deregisterMicroServices(this.getAddress());
    }

    @NotNull
    protected String getDialogName() {
        return "MessagePanel";
    }

    @NotNull
    protected ILogger getLogger() {
        return LOG;
    }
}

