/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dialog.user;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.dialog.password.change.CConstantsDialogPasswordChange;
import de.sillysky.nyssr.dialog.password.change.records.CRecordOpenDialogPasswordChange;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.impl.dialog.user.C700Handler;
import de.sillysky.nyssr.impl.dialog.user.C701Handler;
import de.sillysky.nyssr.impl.dialog.user.C702Handler;
import de.sillysky.nyssr.impl.dialog.user.C703Handler;
import de.sillysky.nyssr.impl.dialog.user.C704Handler;
import de.sillysky.nyssr.impl.dialog.user.C705Handler;
import de.sillysky.nyssr.impl.dialog.user.C706Handler;
import de.sillysky.nyssr.impl.dialog.user.C707Handler;
import de.sillysky.nyssr.impl.dialog.user.C708Handler;
import de.sillysky.nyssr.impl.dialog.user.CButtonAndRight;
import de.sillysky.nyssr.impl.dialog.user.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.login.records.CRecordSessionCreateRight;
import de.sillysky.nyssr.login.records.CRecordSessionValidate;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.panel.records.CRecordAddMessages;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.server.connector.IRemoteSkinClientContext;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.dialog.CDialogDto;
import de.sillysky.nyssr.remoteskin.server.dialog.CUtilDialogHelper;
import de.sillysky.nyssr.remoteskin.server.dialog.records.CRecordOpenDialog;
import de.sillysky.nyssr.remoteskin.server.dialoghelper.IDialogFlavor;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.session.CConstantsSession;
import de.sillysky.nyssr.session.api.CRight;
import de.sillysky.nyssr.session.api.CRightList;
import de.sillysky.nyssr.session.api.CRole;
import de.sillysky.nyssr.session.api.CUser;
import de.sillysky.nyssr.session.api.records.CRecordUserDbAddRolesToUser;
import de.sillysky.nyssr.session.api.records.CRecordUserDbCreateRole;
import de.sillysky.nyssr.session.api.records.CRecordUserDbCreateUser;
import de.sillysky.nyssr.session.api.records.CRecordUserDbDeleteRight;
import de.sillysky.nyssr.session.api.records.CRecordUserDbDeleteRole;
import de.sillysky.nyssr.session.api.records.CRecordUserDbDeleteUser;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetRightList;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetRightListForRole;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetRoleList;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetRoleRecord;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetUserList;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetUserRecord;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGrantRightToRole;
import de.sillysky.nyssr.session.api.records.CRecordUserDbRemoveRolesFromUser;
import de.sillysky.nyssr.session.api.records.CRecordUserDbRevokeRightFromRole;
import de.sillysky.nyssr.session.api.records.CRecordUserDbUpdateUserRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilStringArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CMainTarget
extends CTarget {
    private static final ILogger LOG = CLoggerFactory.getLogger((String)"dialog.user");
    private static final String[] JSON = new String[]{"/json/700_Main.json", "/json/701_EditUser.json", "/json/702_ChooseRoles.json", "/json/703_CreateUser.json", "/json/704_EditRights.json", "/json/705_AddRight.json", "/json/706_EditRoles.json", "/json/707_EditRole.json", "/json/708_ChooseRights.json", "/json/709_PopupMenu.json"};
    private static final String KEY_SLOT_NEXT_DIALOG = "10000";
    private final String mInstance;
    private final IDependencies mDependencies;
    private final CDialogDto mDialogDto;
    private final CTargetAddress mAddressForDisplayingMessages;
    private C700Handler m700Handler;
    private C701Handler m701Handler;
    private C702Handler m702Handler;
    private C703Handler m703Handler;
    private C704Handler m704Handler;
    private C705Handler m705Handler;
    private C706Handler m706Handler;
    private C707Handler m707Handler;
    private C708Handler m708Handler;
    private CButtonAndRight mButtonAndRight;
    private CTargetAddress mUserDbAddress;
    private CUser mUser;
    private String[] mRolesOfUser;
    private String mNextUser;
    private String[] mSessionRights;
    private String mSessionUserId;
    private IDialogFlavor mDialogFlavor;

    CMainTarget(@NotNull IDependencies aDependencies, @NotNull CDialogDto aDialogDto, @NotNull CRecord aRecord) {
        this.mDependencies = aDependencies;
        this.mDialogDto = aDialogDto;
        this.mAddressForDisplayingMessages = CRecordOpenDialog.getAddressForDisplayingMessages((CRecord)aRecord, null);
        this.mInstance = aDialogDto.getParentWidgetId().getWidgetSetId().getInstance();
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordSessionValidate.ID, this::asyncSessionValidate);
        this.addMessageHandler(CRecordUserDbGetUserList.ID, this::asyncGetUserList);
        this.addMessageHandler(CRecordUserDbGetUserRecord.ID, this::asyncGetUserRecord);
        this.addMessageHandler(CRecordUserDbUpdateUserRecord.ID, this::asyncUpdateUserData);
        this.addMessageHandler(CRecordUserDbGetRoleList.ID, this::asyncGetAllRoles);
        this.addMessageHandler(CRecordUserDbGetRightList.ID, this::asyncGetAllRights);
        this.addMessageHandler(CRecordUserDbAddRolesToUser.ID, this::asyncAddRolesToUser);
        this.addMessageHandler(CRecordUserDbRemoveRolesFromUser.ID, this::asyncRemoveRolesFromUser);
        this.addMessageHandler(CRecordUserDbCreateUser.ID, this::asyncAddUser);
        this.addMessageHandler(CRecordUserDbDeleteUser.ID, this::asyncRemoveUser);
        this.addMessageHandler(CRecordSessionCreateRight.ID, this::asyncCreateRight);
        this.addMessageHandler(CRecordUserDbDeleteRight.ID, this::asyncDeleteRight);
        this.addMessageHandler(CRecordUserDbGetRoleRecord.ID, this::asyncGetRole);
        this.addMessageHandler(CRecordUserDbGetRightListForRole.ID, this::asyncGetRightListForRole);
        this.addMessageHandler(CRecordUserDbCreateRole.ID, this::asyncCreateRole);
        this.addMessageHandler(CRecordUserDbDeleteRole.ID, this::asyncDeleteRole);
        this.addMessageHandler(CRecordUserDbGrantRightToRole.ID, this::asyncAddRightToRole);
        this.addMessageHandler(CRecordUserDbRevokeRightFromRole.ID, this::asyncRevokeRight);
        this.mDialogFlavor = this.mDependencies.getDialogFlavorFactory().createHelper(this.mDialogDto);
        this.mDialogFlavor.initialize((CTarget)this, JSON);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        LOG.info("Start User Target");
        this.sendGetSessionData();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncSessionValidate(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            if (aEnvelope.getResultCode() == 0) {
                this.mSessionUserId = CRecordSessionValidate.getUserId((CRecord)aRecord, null);
                this.mSessionRights = CRecordSessionValidate.getRights((CRecord)aRecord, null);
                if (this.mButtonAndRight == null) {
                    IRemoteSkinServerContext serverContext = this.mDialogDto.getServerContext();
                    this.mButtonAndRight = new CButtonAndRight(this.mSessionRights, this.mSessionUserId, serverContext.getWidgetApi());
                    this.m700Handler = new C700Handler(this, serverContext, this.mInstance, this.mButtonAndRight);
                    this.m701Handler = new C701Handler(this, serverContext, this.mInstance);
                    this.m702Handler = new C702Handler(this, serverContext, this.mInstance);
                    this.m703Handler = new C703Handler(this, serverContext, this.mInstance);
                    this.m704Handler = new C704Handler(this, serverContext, this.mInstance, this.mButtonAndRight);
                    this.m705Handler = new C705Handler(this, serverContext, this.mInstance);
                    this.m706Handler = new C706Handler(this, serverContext, this.mInstance, this.mButtonAndRight);
                    this.m707Handler = new C707Handler(this, serverContext, this.mInstance);
                    this.m708Handler = new C708Handler(this, serverContext, this.mInstance);
                    this.m700Handler.mount(this.mDialogDto.getParentWidgetId());
                } else {
                    this.mButtonAndRight.setSessionData(this.mSessionUserId, this.mSessionRights);
                }
            } else {
                this.addMessage(true, "Session Manager not found.", new Object[0]);
            }
            return true;
        }
        return false;
    }

    private boolean asyncGetUserList(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            if (aEnvelope.getResult().isSuccess()) {
                this.mUserDbAddress = aEnvelope.getSender();
                String[] userIds = CRecordUserDbGetUserList.getUserIds((CRecord)aRecord, null);
                this.m700Handler.fillUserIdList(userIds);
                if (this.mNextUser != null) {
                    this.m700Handler.selectUserInList(this.mNextUser);
                    this.mNextUser = null;
                }
                this.sendUpdate();
            }
            return true;
        }
        return false;
    }

    private boolean asyncGetAllRoles(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            if (aEnvelope.getResult().isSuccess()) {
                int nextDialog = 0;
                String[] roles = CRecordUserDbGetRoleList.getRoles((CRecord)aRecord, null);
                Object o = aRecord.getValue(KEY_SLOT_NEXT_DIALOG);
                if (o instanceof Integer) {
                    nextDialog = (Integer)o;
                }
                if (roles != null) {
                    List<String> sorted;
                    ArrayList<String> roleList = new ArrayList<String>(Arrays.asList(roles));
                    if (nextDialog == 702) {
                        Arrays.stream(this.mRolesOfUser).forEach(roleList::remove);
                        List<String> sorted2 = roleList.stream().sorted(String::compareTo).collect(Collectors.toList());
                        this.showDialog702ChooseRoles(this.m700Handler.getMainPanel(), sorted2);
                        return true;
                    }
                    if (nextDialog == 706) {
                        sorted = roleList.stream().sorted(String::compareTo).collect(Collectors.toList());
                        if (!this.m706Handler.isShown()) {
                            this.showDialog706EditRoles(this.m700Handler.getMainPanel(), sorted);
                            return true;
                        }
                    }
                    sorted = roleList.stream().sorted(String::compareTo).collect(Collectors.toList());
                    this.m706Handler.setRoles(sorted, "Administrator");
                }
            }
            return true;
        }
        return false;
    }

    private boolean asyncGetAllRights(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            CRecord[] rightRecords;
            if (aEnvelope.getResult().isSuccess() && (rightRecords = CRecordUserDbGetRightList.getRights((CRecord)aRecord, null)) != null) {
                ArrayList<CRight> rightList = new ArrayList<CRight>();
                for (CRecord rightRecord : rightRecords) {
                    CRight right = CRight.fromRecord((CRecord)rightRecord);
                    rightList.add(right);
                }
                List<CRight> sorted = rightList.stream().sorted(CRight::compareTo).collect(Collectors.toList());
                this.m704Handler.setRights(sorted);
                this.m708Handler.setAllRights(sorted);
            }
            return true;
        }
        return false;
    }

    private boolean asyncAddRolesToUser(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            String userId = CRecordUserDbAddRolesToUser.getUserId((CRecord)aRecord, (String)"");
            String[] rolesArray = CRecordUserDbAddRolesToUser.getRoles((CRecord)aRecord, (String[])new String[0]);
            String roles = CUtilStringArray.toStringWithColon((String[])rolesArray);
            if (aEnvelope.getResult().isSuccess()) {
                this.addMessage(false, "Roles %s added to user %s", roles, userId);
                this.sendGetUserData(userId);
                if (this.mSessionUserId.equals(userId)) {
                    this.sendGetSessionData();
                }
            } else {
                this.addMessage(true, "Couldn't add roles %s to user %s", roles, userId);
            }
            return true;
        }
        return false;
    }

    private boolean asyncGetUserRecord(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            if (aEnvelope.getResult().isSuccess()) {
                CRecord userRecord = CRecordUserDbGetUserRecord.getUser((CRecord)aRecord, null);
                this.mUser = CUser.fromRecord((CRecord)userRecord);
                this.mRolesOfUser = CRecordUserDbGetUserRecord.getRoles((CRecord)aRecord, (String[])new String[0]);
                CRecord[] rightRecords = CRecordUserDbGetUserRecord.getRights((CRecord)aRecord, null);
                CRightList rights = CRightList.fromRecordArray((CRecord[])rightRecords);
                this.m700Handler.updateUser(this.mUser, this.mRolesOfUser, rights);
            }
            return true;
        }
        return false;
    }

    private boolean asyncRemoveRolesFromUser(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            String userId = CRecordUserDbRemoveRolesFromUser.getUserId((CRecord)aRecord, (String)"");
            String[] rolesArray = CRecordUserDbRemoveRolesFromUser.getRoles((CRecord)aRecord, (String[])new String[0]);
            String roles = CUtilStringArray.toStringWithColon((String[])rolesArray);
            if (aEnvelope.getResult().isSuccess()) {
                this.addMessage(false, "Roles %s removed from user %s", roles, userId);
                this.sendGetUserData(userId);
            } else {
                this.addMessage(true, "Couldn't remove roles %s from user %s", roles, userId);
            }
            return true;
        }
        return false;
    }

    private boolean asyncUpdateUserData(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            if (aEnvelope.getResult().isSuccess()) {
                String userId = CRecordUserDbUpdateUserRecord.getUserId((CRecord)aRecord, (String)"");
                this.sendGetUserData(userId);
                this.addMessage(false, "User data updated", new Object[0]);
            } else {
                this.addMessage(true, "No right to edit user data: %s", aEnvelope.getResultText());
            }
            return true;
        }
        return false;
    }

    private boolean asyncAddUser(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            String user = CRecordUserDbCreateUser.getUserId((CRecord)aRecord, (String)"");
            if (aEnvelope.getResult().isSuccess()) {
                this.addMessage(false, "User %s created.", user);
                this.mNextUser = CRecordUserDbCreateUser.getUserId((CRecord)aRecord, (String)"");
                this.sendGetUserList();
                this.m703Handler.unmount();
            } else {
                String resultText = aEnvelope.getResultText();
                this.addMessage(true, "Couldn't create user %s: %s", user, resultText);
                this.m703Handler.addMessage(resultText);
                this.m703Handler.sendUpdate();
            }
            return true;
        }
        return false;
    }

    private boolean asyncCreateRight(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            String right = CRecordSessionCreateRight.getRight((CRecord)aRecord, (String)"");
            CResult result = aEnvelope.getResult();
            if (result.isSuccess()) {
                this.addMessage(false, "Right %s created.", right);
                this.sendGetAllRights();
            } else {
                this.addMessage(true, "Error creating right %s: %s", right, result.getText());
            }
            return true;
        }
        return false;
    }

    private boolean asyncDeleteRight(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            String right = CRecordUserDbDeleteRight.getRight((CRecord)aRecord, (String)"");
            if (aEnvelope.getResult().isSuccess()) {
                this.sendGetAllRights();
                this.addMessage(false, "Right %s removed.", right);
            } else {
                this.addMessage(true, "Right %s couldn't be removed: %s", right, aEnvelope.getResultText());
            }
            return true;
        }
        return false;
    }

    private boolean asyncGetRole(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            String roleId = CRecordUserDbGetRoleRecord.getRoleId((CRecord)aRecord, (String)"");
            if (aEnvelope.getResult().isSuccess()) {
                int nextDialog = 0;
                CRecord roleRecord = CRecordUserDbGetRoleRecord.getRoleRecord((CRecord)aRecord, null);
                CRole role = CRole.fromRecord((CRecord)roleRecord);
                Object o = aRecord.getValue(KEY_SLOT_NEXT_DIALOG);
                if (o instanceof Integer) {
                    nextDialog = (Integer)o;
                }
                if (nextDialog == 707) {
                    this.showDialog707EditRole(this.m700Handler.getMainPanel(), role);
                }
            } else {
                this.addMessage(true, "Role %s unknown: %s", roleId, aEnvelope.getResultText());
            }
            return true;
        }
        return false;
    }

    private boolean asyncCreateRole(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            if (aEnvelope.getResult().isSuccess()) {
                CRecord record;
                int nextDialog = 0;
                Object o = aRecord.getValue(KEY_SLOT_NEXT_DIALOG);
                if (o instanceof Integer) {
                    nextDialog = (Integer)o;
                }
                if ((record = CRecordUserDbCreateRole.getRoleRecord((CRecord)aRecord, null)) != null) {
                    CRole role = CRole.fromRecord((CRecord)record);
                    this.addMessage(true, "Role %s created", role.getId());
                }
                if (nextDialog == 707) {
                    this.m707Handler.unmount();
                    this.sendGetAllRoles(706);
                }
            } else {
                this.addMessage(true, "Can't create the role: %s", aEnvelope.getResultText());
            }
            return true;
        }
        return false;
    }

    private boolean asyncDeleteRole(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            String roleId = CRecordUserDbDeleteRole.getRoleId((CRecord)aRecord, null);
            if (aEnvelope.getResult().isSuccess()) {
                this.addMessage(true, "Role %s deleted", roleId);
                this.sendGetAllRoles(706);
            } else {
                this.addMessage(true, "Can't delete the role %s: %s", roleId, aEnvelope.getResultText());
            }
            return true;
        }
        return false;
    }

    private boolean asyncAddRightToRole(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            String roleId = CRecordUserDbGrantRightToRole.getRoleId((CRecord)aRecord, null);
            String rightId = CRecordUserDbGrantRightToRole.getRightId((CRecord)aRecord, null);
            if (aEnvelope.getResult().isSuccess()) {
                this.addMessage(true, "Added right %s to role %s", rightId, roleId);
                this.sendGetRightList(roleId);
            } else {
                this.addMessage(true, "Couldn't add right %s to the role %s: %s", rightId, roleId, aEnvelope.getResultText());
            }
            return true;
        }
        return false;
    }

    private boolean asyncRevokeRight(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            String roleId = CRecordUserDbRevokeRightFromRole.getRoleId((CRecord)aRecord, null);
            String rightId = CRecordUserDbRevokeRightFromRole.getRightId((CRecord)aRecord, null);
            if (aEnvelope.getResult().isSuccess()) {
                this.addMessage(true, "Right %s revoked from role %s", rightId, roleId);
                this.sendGetRightList(roleId);
            } else {
                this.addMessage(true, "Couldn't revoke right %s from role %s: %s", rightId, roleId, aEnvelope.getResultText());
            }
            return true;
        }
        return false;
    }

    private boolean asyncGetRightListForRole(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            String roleId = CRecordUserDbGetRightListForRole.getRoleId((CRecord)aRecord, (String)"");
            if (aEnvelope.getResult().isSuccess()) {
                ArrayList<CRight> rights = new ArrayList<CRight>();
                CRecord[] rightRecords = CRecordUserDbGetRightListForRole.getRights((CRecord)aRecord, null);
                if (rightRecords != null) {
                    for (CRecord rightRecord : rightRecords) {
                        CRight right = CRight.fromRecord((CRecord)rightRecord);
                        rights.add(right);
                    }
                }
                this.m706Handler.setRights(roleId, rights);
                this.m708Handler.setRightsOfRole(roleId, rights);
            }
            return true;
        }
        return false;
    }

    private boolean asyncRemoveUser(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            String userId = CRecordUserDbDeleteUser.getUserId((CRecord)aRecord, (String)"");
            if (aEnvelope.getResult().isSuccess()) {
                this.mNextUser = "admin";
                this.sendGetUserList();
                this.addMessage(false, "User %s removed.", userId);
            } else {
                this.addMessage(true, "Error removing user %s", userId);
            }
            return true;
        }
        return false;
    }

    void notifyWs700Loaded() throws CException {
        LOG.info("Ws700 loaded");
        this.sendGetUserList();
    }

    void addMessage(boolean aIsError, String aMessage, Object ... aArgs) {
        String s = String.format(aMessage, aArgs);
        if (aIsError) {
            LOG.error(s);
        } else {
            LOG.debug(s);
        }
        this.displayMessage(s);
    }

    void displayMessage(@NotNull String aText) {
        if (this.mAddressForDisplayingMessages != null) {
            try {
                CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mAddressForDisplayingMessages);
                CRecord rec = CRecordAddMessages.create();
                CRecordAddMessages.setMessages((CRecord)rec, (String[])new String[]{aText});
                this.sendNotification(env, rec);
            }
            catch (CException aE) {
                LOG.error("Couldn't send Message {}", new Object[]{aText});
            }
        }
    }

    private void sendMessageToSessionManager(@NotNull CRecord aRecord) throws CException {
        CEnvelope env = this.mUserDbAddress != null ? CEnvelope.forSingleTarget((CTargetAddress)this.mUserDbAddress) : CEnvelope.forMicroService((IId)CConstantsSession.MICRO_SERVICE_ID);
        env.setSessionToken(this.mDialogDto.getSessionToken());
        this.sendRequest(env, aRecord);
    }

    private void sendGetAllRoles(int aNextDialog) throws CException {
        CRecord record = CRecordUserDbGetRoleList.create();
        record.setValue(KEY_SLOT_NEXT_DIALOG, CCommonSlotType.INT, (Object)aNextDialog);
        this.sendMessageToSessionManager(record);
    }

    private void sendGetAllRights() throws CException {
        CRecord record = CRecordUserDbGetRightList.create();
        this.sendMessageToSessionManager(record);
    }

    private void sendGetUserList() throws CException {
        CRecord record = CRecordUserDbGetUserList.create();
        this.sendMessageToSessionManager(record);
    }

    void sendGetUserData(@NotNull String aId) throws CException {
        CRecord record = CRecordUserDbGetUserRecord.create();
        CRecordUserDbGetUserRecord.setUserId((CRecord)record, (String)aId);
        this.sendMessageToSessionManager(record);
    }

    void sendUpdate() {
        this.mDialogDto.getServerContext().sendUpdate();
    }

    void sendUpdateUserData(@NotNull String aUserId, @NotNull String aRealName, @NotNull String aEmail) throws CException {
        CRecord record = CRecordUserDbUpdateUserRecord.create();
        CRecordUserDbUpdateUserRecord.setUserId((CRecord)record, (String)aUserId);
        CRecordUserDbUpdateUserRecord.setRealName((CRecord)record, (String)aRealName);
        CRecordUserDbUpdateUserRecord.setEmail((CRecord)record, (String)aEmail);
        this.sendMessageToSessionManager(record);
        this.addMessage(false, "Update user %s: RealName=%s, EMail=%s", aUserId, aRealName, aEmail);
    }

    void notifyButtonAddUserPressed() {
        this.m703Handler.mount(this.m700Handler.getMainPanel());
    }

    void notifyButtonEditUser() {
        this.m701Handler.mount(this.m700Handler.getMainPanel(), this.mUser);
    }

    void notifyButtonAddRolePressed() throws CException {
        this.sendGetAllRoles(702);
    }

    void sendAddRight(@NotNull String aUserId, @NotNull Collection<String> aNewRoles) throws CException {
        CRecord record = CRecordUserDbAddRolesToUser.create();
        CRecordUserDbAddRolesToUser.setUserId((CRecord)record, (String)aUserId);
        String[] array = aNewRoles.toArray(new String[0]);
        CRecordUserDbAddRolesToUser.setRoles((CRecord)record, (String[])array);
        this.sendMessageToSessionManager(record);
        this.addMessage(false, "Add roles to user %s: %s", aUserId, CUtilStringArray.toString((String[])array, (int)0, (int)array.length, (char)',', (int)1000, (char)'\\'));
    }

    void sendAddRight(@NotNull String aNewRight, @NotNull String aDescription) throws CException {
        CRecord record = CRecordSessionCreateRight.create();
        CRecordSessionCreateRight.setRight((CRecord)record, (String)aNewRight);
        CRecordSessionCreateRight.setDescription((CRecord)record, (String)aDescription);
        this.sendMessageToSessionManager(record);
        this.addMessage(false, "Add new right: %s - %s", aNewRight, aDescription);
    }

    void notifyButtonRemoveRolePressed(@NotNull String aUserId, @NotNull ArrayList<String> aRoles) throws CException {
        this.sendRemoveRoles(aUserId, aRoles);
    }

    void sendRemoveRoles(@NotNull String aUserId, @NotNull Collection<String> aRolesToRemove) throws CException {
        CRecord record = CRecordUserDbRemoveRolesFromUser.create();
        CRecordUserDbRemoveRolesFromUser.setUserId((CRecord)record, (String)aUserId);
        String[] array = aRolesToRemove.toArray(new String[0]);
        CRecordUserDbRemoveRolesFromUser.setRoles((CRecord)record, (String[])array);
        this.sendMessageToSessionManager(record);
        this.addMessage(false, "Remove roles from user %s: %s", aUserId, CUtilStringArray.toString((String[])array, (int)0, (int)array.length, (char)',', (int)1000, (char)'\\'));
    }

    void sendAddUser(@NotNull CUser aUser) throws CException {
        CRecord record = CRecordUserDbCreateUser.create();
        CRecordUserDbCreateUser.setUserId((CRecord)record, (String)aUser.getId());
        CRecordUserDbCreateUser.setRealName((CRecord)record, (String)aUser.getRealName());
        CRecordUserDbCreateUser.setEmail((CRecord)record, (String)aUser.getEmail());
        CRecordUserDbCreateUser.setPassword((CRecord)record, (String)aUser.getPassword());
        this.sendMessageToSessionManager(record);
        this.addMessage(false, "Add user %s", aUser);
    }

    void sendRemoveUser(@NotNull String aUserId) throws CException {
        CRecord record = CRecordUserDbDeleteUser.create();
        CRecordUserDbDeleteUser.setUserId((CRecord)record, (String)aUserId);
        this.sendMessageToSessionManager(record);
        this.addMessage(false, "Remove user %s", aUserId);
    }

    void notifyButtonRemoveUserPressed(@NotNull String aUserId) throws CException {
        this.sendRemoveUser(aUserId);
    }

    void notifyButtonEditRights() throws CException {
        this.m704Handler.mount(this.m700Handler.getMainPanel());
        this.sendGetAllRights();
    }

    void showDialog702ChooseRoles(@NotNull CWidgetId aParent, @NotNull Collection<String> aRoles) {
        this.m702Handler.mount(aParent, this.mUser, aRoles);
    }

    void showDialog705NewRight(@NotNull CWidgetId aParent) {
        this.m705Handler.mount(aParent);
    }

    void showDialog706EditRoles(@NotNull CWidgetId aParent, @NotNull Collection<String> aRoles) {
        this.m706Handler.mount(aParent, aRoles);
    }

    void showDialog707EditRole(@NotNull CWidgetId aParent, @Nullable CRole aRole) {
        this.m707Handler.mount(aParent, aRole);
    }

    void showDialog708ChooseRight(@NotNull CWidgetId aParent, @NotNull String aRoleId) {
        this.m708Handler.mount(aParent, aRoleId);
    }

    void sendRemoveRights(@NotNull List<String> aRights) throws CException {
        for (String right : aRights) {
            CRecord record = CRecordUserDbDeleteRight.create();
            CRecordUserDbDeleteRight.setRight((CRecord)record, (String)right);
            this.sendMessageToSessionManager(record);
            this.addMessage(false, "Delete right permanently: %s", right);
        }
    }

    void notifyButtonEditRoles() throws CException {
        this.sendGetAllRoles(706);
    }

    void sendCreateRole(@NotNull CRole aRole) throws CException {
        CRecord record = CRecordUserDbCreateRole.create();
        CRecord record1 = aRole.toRecord();
        CRecordUserDbCreateRole.setRoleRecord((CRecord)record, (CRecord)record1);
        record.setValue(KEY_SLOT_NEXT_DIALOG, CCommonSlotType.INT, (Object)707);
        this.sendMessageToSessionManager(record);
        this.addMessage(false, "Create role: %s", aRole.getId());
    }

    void sendUpdateRoleData(@NotNull CRole aRole) {
    }

    void notifyButton706CreateRolePressed() {
        this.showDialog707EditRole(this.m700Handler.getMainPanel(), null);
    }

    void notifyButton706EditRoleDataPressed(String aRoleId) throws CException {
        this.sendGetRole(aRoleId, 707);
    }

    private void sendGetRole(String aRoleId, int aNextDialog) throws CException {
        CRecord record = CRecordUserDbGetRoleRecord.create();
        CRecordUserDbGetRoleRecord.setRoleId((CRecord)record, (String)aRoleId);
        record.setValue(KEY_SLOT_NEXT_DIALOG, CCommonSlotType.INT, (Object)aNextDialog);
        this.sendMessageToSessionManager(record);
    }

    void sendGetRightList(@NotNull String aRoleId) throws CException {
        CRecord record = CRecordUserDbGetRightListForRole.create();
        CRecordUserDbGetRightListForRole.setRoleId((CRecord)record, (String)aRoleId);
        this.sendMessageToSessionManager(record);
    }

    void sendDeleteRole(@NotNull String aSelectedRole) throws CException {
        CRecord record = CRecordUserDbDeleteRole.create();
        CRecordUserDbDeleteRole.setRoleId((CRecord)record, (String)aSelectedRole);
        this.addMessage(false, "Delete role permanently: %s", aSelectedRole);
        this.sendMessageToSessionManager(record);
    }

    void notifyButton706GrantRightPressed(@NotNull CWidgetId aParent, @NotNull String aRoleId) throws CException {
        this.showDialog708ChooseRight(aParent, aRoleId);
        this.sendGetRightList(aRoleId);
        this.sendGetAllRights();
    }

    void sendRevokeRights(@NotNull String aRoleId, @NotNull Collection<String> aRights) throws CException {
        for (String right : aRights) {
            CRecord record = CRecordUserDbRevokeRightFromRole.create();
            CRecordUserDbRevokeRightFromRole.setRoleId((CRecord)record, (String)aRoleId);
            CRecordUserDbRevokeRightFromRole.setRightId((CRecord)record, (String)right);
            this.addMessage(false, "Revoke right %s from role %s", right, aRoleId);
            this.sendMessageToSessionManager(record);
        }
    }

    void notify708ButtonOkayPressed(@NotNull String aRoleId, @NotNull Collection<String> aRights) throws CException {
        this.sendAddRightsToRole(aRoleId, aRights);
    }

    private void sendAddRightsToRole(@NotNull String aRoleId, @NotNull Collection<String> aRights) throws CException {
        for (String right : aRights) {
            CRecord record = CRecordUserDbGrantRightToRole.create();
            CRecordUserDbGrantRightToRole.setRoleId((CRecord)record, (String)aRoleId);
            CRecordUserDbGrantRightToRole.setRightId((CRecord)record, (String)right);
            this.addMessage(false, "Add right %s to role %s", right, aRoleId);
            this.sendMessageToSessionManager(record);
        }
    }

    private void sendGetSessionData() throws CException {
        CRecord record = CRecordSessionValidate.create();
        this.sendMessageToSessionManager(record);
    }

    void update706() throws CException {
        this.sendGetRightList(this.m706Handler.getRoleId());
    }

    void notifyButtonChangePassword(@NotNull CWidgetId aParentWidget) throws CException {
        CEnvelope env = CEnvelope.forMicroService((IId)CConstantsDialogPasswordChange.MICRO_SERVICE_ID);
        env.setSessionToken(this.mDialogDto.getSessionToken());
        CRecord record = CRecordOpenDialogPasswordChange.create();
        CRecordOpenDialogPasswordChange.setUserId((CRecord)record, (String)this.mSessionUserId);
        CUtilDialogHelper.enrichOpenDialogRecord((CRecord)record, (IRemoteSkinClientContext)this.mDialogDto.getClientContext(), (CWidgetId)aParentWidget);
        this.sendRequest(env, record);
    }

    String getSessionUserId() {
        return this.mSessionUserId;
    }

    String[] getSessionRights() {
        return this.mSessionRights;
    }
}

