/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.file.store.getfile;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.file.store.api.EFileDeliveryType;
import de.sillysky.nyssr.file.store.records.CRecordFileStoreRequestFile;
import de.sillysky.nyssr.impl.file.store.database.CFileEntry;
import de.sillysky.nyssr.impl.file.store.getfile.CDownloadFileJob;
import de.sillysky.nyssr.impl.file.store.getfile.CPendingGetFileRequest;
import de.sillysky.nyssr.impl.file.store.records.CRecordFileStoreNotifyFileDownloaded;
import de.sillysky.nyssr.impl.file.store.service.IFileStore;
import de.sillysky.nyssr.job.IJob;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.files.CUtilPath;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CIncomingRequestFileHandler {
    private static final ILogger LOG = CLoggerFactory.getLogger(CIncomingRequestFileHandler.class);
    private final IFileStore mFileStore;
    private final List<CPendingGetFileRequest> mPendingGetFileRequests = new ArrayList<CPendingGetFileRequest>();

    public CIncomingRequestFileHandler(@NotNull IFileStore aFileStore) {
        this.mFileStore = aFileStore;
    }

    public boolean asyncRequestFile(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        CFileEntry e;
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String path = CRecordFileStoreRequestFile.getPath((CRecord)aRecord, null);
        String hash = CRecordFileStoreRequestFile.getHash((CRecord)aRecord, null);
        LOG.debug("File requested: path={}, hash={}", new Object[]{path, hash});
        if (CUtilString.isValid((String)hash)) {
            LOG.debug("File requested by hash={}", new Object[]{hash});
            e = this.mFileStore.getFileEntryByHash(hash);
        } else if (CUtilString.isValid((String)path)) {
            LOG.debug("File requested by path={}", new Object[]{path});
            path = CUtilPath.normalizeSlashesInPath((String)path);
            e = this.mFileStore.getFileEntryByPath(path);
        } else {
            throw new CException(7).append("Hash or path must be valid");
        }
        if (e != null) {
            LOG.debug("Cached file delivered: {}", new Object[]{path});
            this.fillAnswerGetFile(aEnvelope, aRecord, e);
        } else {
            aEnvelope.setBlocked(true);
            CMessage msg = new CMessage(aEnvelope, aRecord);
            boolean doRequest = this.addRequestIfNotAlreadyPending(hash, path, msg);
            if (doRequest) {
                CDownloadFileJob job = new CDownloadFileJob(this.mFileStore, path, hash);
                this.mFileStore.getJobEngine().appendJob((IJob)job);
            }
        }
        return true;
    }

    public boolean asyncNotifyFileDownloaded(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CFileEntry fileEntry = null;
        int resultCode = CRecordFileStoreNotifyFileDownloaded.getResultCode(aRecord, 0);
        String requestedPath = CRecordFileStoreNotifyFileDownloaded.getPath(aRecord, null);
        String requestedHash = CRecordFileStoreNotifyFileDownloaded.getHash(aRecord, null);
        for (CPendingGetFileRequest r : this.mPendingGetFileRequests) {
            if (!r.match(requestedHash, requestedPath)) continue;
            if (resultCode == 0) {
                CRecord recFile = CRecordFileStoreNotifyFileDownloaded.getFileEntry(aRecord, null);
                fileEntry = CFileEntry.fromRecord(recFile);
                byte[] bytes = CRecordFileStoreNotifyFileDownloaded.getBytes(aRecord, null);
                fileEntry.setBytes(bytes);
                File file = (File)CRecordFileStoreNotifyFileDownloaded.getFile(aRecord, null);
                fileEntry.setFile(file);
                String hash = fileEntry.getHash();
                String path = fileEntry.getRelativePath();
                this.mFileStore.addNewFileEntry(fileEntry);
                LOG.debug("File delivered: path={}, hash={}", new Object[]{path, hash});
            }
            Collection<CMessage> messages = r.getMessages();
            for (CMessage msg : messages) {
                CRecord record = msg.getRecord();
                CEnvelope envelope = msg.getEnvelope();
                if (fileEntry != null) {
                    this.fillAnswerGetFile(envelope, record, fileEntry);
                }
                String resultText = CRecordFileStoreNotifyFileDownloaded.getResultText(aRecord, "");
                envelope.setResult(resultCode, resultText);
                envelope.setBlocked(false);
                this.mFileStore.getTarget().getMessageSender().sendBack(msg);
            }
        }
        return true;
    }

    private boolean addRequestIfNotAlreadyPending(@Nullable String aHash, @Nullable String aPath, @NotNull CMessage aMessage) {
        for (CPendingGetFileRequest r : this.mPendingGetFileRequests) {
            if (!r.match(aHash, aPath)) continue;
            r.addMessage(aMessage);
            return false;
        }
        CPendingGetFileRequest pm = new CPendingGetFileRequest(aHash, aPath);
        pm.addMessage(aMessage);
        this.mPendingGetFileRequests.add(pm);
        return true;
    }

    void fillAnswerGetFile(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord, @NotNull CFileEntry aEntry) throws CException {
        int resultCode = 0;
        String resultText = "";
        CRecord record = aEntry.toRecord();
        CRecordFileStoreRequestFile.setFileRecord((CRecord)aRecord, (CRecord)record);
        byte deliveryType = CRecordFileStoreRequestFile.getDeliveryType((CRecord)aRecord, (byte)EFileDeliveryType.BYTES.getType());
        File file = aEntry.getFile();
        if (deliveryType == EFileDeliveryType.FILE.getType()) {
            if (file == null) {
                resultCode = 3;
                resultText = "Delivery type FILE not supported, because we have no directory";
            } else {
                CRecordFileStoreRequestFile.setFile((CRecord)aRecord, (Object)file);
            }
        } else if (aEntry.getFileLength() > 0L) {
            byte[] bytes = aEntry.getBytes();
            if (bytes != null) {
                CRecordFileStoreRequestFile.setBytes((CRecord)aRecord, (byte[])bytes);
            } else if (file == null) {
                resultCode = 15;
                resultText = "Internal Error, File is null";
            } else {
                try {
                    bytes = Files.readAllBytes(file.toPath());
                    CRecordFileStoreRequestFile.setBytes((CRecord)aRecord, (byte[])bytes);
                }
                catch (IOException aException) {
                    resultCode = 2201;
                    resultText = aException.getMessage();
                }
            }
        }
        aEnvelope.setResult(resultCode, resultText);
    }
}

