/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.widget.showcase.slider;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.app.widget.showcase.slider.CSliderModel;
import de.sillysky.nyssr.remoteskin.model.events.CEventInteger;
import de.sillysky.nyssr.remoteskin.model.util.EMessageBoxType;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IDialogButtonListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IIntegerListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.remoteskin.server.widgets.CMessageBox;
import org.jetbrains.annotations.NotNull;

public class CSliderUi {
    private final CSliderModel mModel;
    private final IRemoteSkinServerContext mServerContext;
    private final IWidgetApi mApi;
    private final CWidgetSetId mWs301;
    private final CWidgetId m301Slider310;
    private final CWidgetId m301Slider311;
    private final CWidgetId m301PanelMain;
    private boolean mMessageBoxShown = false;

    public CSliderUi(@NotNull CSliderModel aModel) {
        this.mModel = aModel;
        this.mServerContext = aModel.getAppContext().getRemoteSkinServerContext();
        this.mApi = this.mServerContext.getWidgetApi();
        this.mWs301 = CWidgetSetId.create((String)"@301_Slider", (String)this.mModel.getParent().getWidgetSetId().getInstance());
        this.m301PanelMain = CWidgetId.create((String)"#301_Panel_Main", (CWidgetSetId)this.mWs301);
        this.m301Slider310 = CWidgetId.create((String)"#301_Component_010", (CWidgetSetId)this.mWs301);
        this.mApi.addListener(this.m301Slider310, (IListener)((IIntegerListener)this::onChange310));
        this.m301Slider311 = CWidgetId.create((String)"#301_Component_011", (CWidgetSetId)this.mWs301);
        this.mApi.addListener(this.m301Slider311, (IListener)((IIntegerListener)this::onChange311));
    }

    private void onChange311(@NotNull CEventInteger aEvent) {
        this.showValue(this.m301Slider311, aEvent.getValue());
    }

    private void onChange310(@NotNull CEventInteger aEvent) {
        this.showValue(this.m301Slider310, aEvent.getValue());
    }

    private void showValue(CWidgetId aParent, int aValue) {
        if (!this.mMessageBoxShown) {
            this.mMessageBoxShown = true;
            CMessageBox msgBox = this.mServerContext.createMessageBox(this.mWs301, "#301MessageBox");
            msgBox.setTitle("Value Changed");
            msgBox.setText("Value is " + aValue);
            msgBox.setButtons(new String[]{"Okay", "Cancel"});
            msgBox.setMessageType(EMessageBoxType.information);
            this.mApi.setParent(msgBox.getWidgetId(), aParent);
            msgBox.setIndexOfEnterButton(0);
            msgBox.setIndexOfEscapeButton(1);
            msgBox.showDialog();
            msgBox.addListener((IListener)((IDialogButtonListener)this::onMessageBox));
            this.mServerContext.sendUpdate();
        }
    }

    private void onMessageBox(String ignore) {
        this.mMessageBoxShown = false;
    }

    private void widgetSet301Mounted(@NotNull CWidgetSetId aWidgetSetId) {
    }

    void mountWidgetSet301() {
        this.mServerContext.mountWidgetSet(this.mWs301, this.mModel.getParent(), "#301_Panel_Main", this::widgetSet301Mounted);
        this.mServerContext.sendUpdate();
    }

    public void dismiss() {
        this.mApi.unmount(this.m301PanelMain);
    }
}

